/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doggytalents.DoggyTalents2;
import doggytalents.client.CachedFileTexture;
import doggytalents.client.SkinRequest;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.entity.texture.DogTextureServer;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.RequestSkinData;
import doggytalents.common.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DogTextureManager
extends DogTextureServer
implements ISelectiveResourceReloadListener {
    public static final DogTextureManager INSTANCE = new DogTextureManager();
    private static final Gson GSON = new Gson();
    private static final ResourceLocation OVERRIDE_RESOURCE_LOCATION = Util.getResource("textures/entity/dog/custom/overrides.json");
    private final Map<String, SkinRequest> hashToSkinRequest = Maps.newConcurrentMap();
    protected final Map<String, ResourceLocation> skinHashToLoc = Maps.newHashMap();
    protected final Map<ResourceLocation, String> locToSkinHash = Maps.newHashMap();
    protected final List<ResourceLocation> customSkinLoc = new ArrayList<ResourceLocation>(20);

    public SkinRequest getRequestStatus(String hash) {
        return this.hashToSkinRequest.getOrDefault(hash, SkinRequest.UNREQUESTED);
    }

    public void setRequestHandled(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.RECEIVED);
    }

    public void setRequestFailed(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.FAILED);
    }

    public void setRequested(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.REQUESTED);
    }

    public List<ResourceLocation> getAll() {
        return Collections.unmodifiableList(this.customSkinLoc);
    }

    public ResourceLocation getLocFromHashOrGet(String hash, Function<? super String, ? extends ResourceLocation> mappingFunction) {
        return this.skinHashToLoc.computeIfAbsent(hash, mappingFunction);
    }

    public String getTextureHash(ResourceLocation loc) {
        return this.locToSkinHash.getOrDefault(loc, "MISSING_MAPPING");
    }

    public ResourceLocation getTextureLoc(String loc) {
        return this.skinHashToLoc.getOrDefault(loc, null);
    }

    public File getClientFolder() {
        Minecraft mc = Minecraft.func_71410_x();
        SkinManager skinManager = mc.func_152342_ad();
        return new File(skinManager.field_152796_d.getParentFile(), "skins_dog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getResourceBytes(ResourceLocation loc) throws IOException {
        InputStream stream = null;
        try {
            stream = this.getResourceStream(loc);
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Nullable
    public InputStream getResourceStream(ResourceLocation loc) throws IOException {
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager resourceManager = mc.func_195551_G();
        IResource resource = resourceManager.func_199002_a(loc);
        return resource.func_199027_b();
    }

    public ResourceLocation getTexture(DogEntity dog) {
        if (dog.hasCustomSkin()) {
            String hash = dog.getSkinHash();
            return INSTANCE.getLocFromHashOrGet(hash, this::getCached);
        }
        return Resources.ENTITY_WOLF;
    }

    public Texture getOrLoadTexture(File baseFolder, String hash) {
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        File cacheFile = this.getCacheFile(baseFolder, hash);
        ResourceLocation loc = this.getResourceLocation(hash);
        Object texture = textureManager.func_229267_b_(loc);
        if (texture == null && cacheFile.isFile() && cacheFile.exists()) {
            texture = new CachedFileTexture(loc, cacheFile);
            textureManager.func_229263_a_(loc, texture);
        }
        return texture;
    }

    public String saveTextureAndLoad(File baseFolder, byte[] data) throws IOException {
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        String hash = this.getHash(data);
        File cacheFile = this.getCacheFile(baseFolder, hash);
        ResourceLocation loc = this.getResourceLocation(hash);
        Texture texture = textureManager.func_229267_b_(loc);
        if (texture == null) {
            DoggyTalents2.LOGGER.debug("Saved dog texture to local cache ({})", (Object)cacheFile);
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])data);
            DoggyTalents2.LOGGER.debug("Texture not current loaded trying to load");
            textureManager.func_229263_a_(loc, (Texture)new CachedFileTexture(loc, cacheFile));
        }
        return hash;
    }

    public ResourceLocation getCached(String hash) {
        if (!ConfigValues.DISPLAY_OTHER_DOG_SKINS) {
            return Resources.ENTITY_WOLF;
        }
        ResourceLocation loc = this.getResourceLocation(hash);
        Texture texture = this.getOrLoadTexture(this.getClientFolder(), hash);
        if (texture != null) {
            return loc;
        }
        if (!this.getRequestStatus(hash).requested()) {
            DoggyTalents2.LOGGER.debug("Marked {} dog skin to be requested from the server", (Object)hash);
            this.setRequested(hash);
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new RequestSkinData(hash));
        }
        return Resources.ENTITY_WOLF;
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.TEXTURES;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test(this.getResourceType())) {
            this.skinHashToLoc.clear();
            this.customSkinLoc.clear();
            Collection resources = resourceManager.func_199003_a("textures/entity/dog/custom", fileName -> fileName.endsWith(".png"));
            for (ResourceLocation rl : resources) {
                try {
                    IResource resource = resourceManager.func_199002_a(rl);
                    if (resource == null) {
                        DoggyTalents2.LOGGER.warn("Could not get resource");
                        continue;
                    }
                    this.loadDogSkinResource(resource);
                }
                catch (FileNotFoundException resource) {
                }
                catch (Exception exception) {
                    DoggyTalents2.LOGGER.warn("Skipped custom dog skin file: {} ({})", (Object)rl, (Object)exception);
                }
            }
            try {
                List resourcelocation = resourceManager.func_199004_b(OVERRIDE_RESOURCE_LOCATION);
                this.loadOverrideData(resourcelocation);
            }
            catch (FileNotFoundException resourcelocation) {
            }
            catch (IOException | RuntimeException runtimeexception) {
                DoggyTalents2.LOGGER.warn("Unable to parse dog skin override data: {}", (Throwable)runtimeexception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadDogSkinResource(IResource resource) {
        InputStream inputstream = null;
        try {
            inputstream = resource.func_199027_b();
            String hash = this.getHash(IOUtils.toByteArray((InputStream)inputstream));
            ResourceLocation rl = resource.func_199029_a();
            if (this.skinHashToLoc.containsKey(hash)) {
                DoggyTalents2.LOGGER.warn("The loaded resource packs contained a duplicate custom dog skin ({} & {})", (Object)resource.func_199029_a(), (Object)this.skinHashToLoc.get(hash));
            } else {
                DoggyTalents2.LOGGER.info("Found custom dog skin at {} with hash {}", (Object)rl, (Object)hash);
                this.skinHashToLoc.put(hash, rl);
                this.locToSkinHash.put(rl, hash);
                this.customSkinLoc.add(rl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOverrideData(List<IResource> resourcesList) {
        for (IResource iresource : resourcesList) {
            InputStream inputstream = iresource.func_199027_b();
            try {
                this.loadLocaleData(inputstream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputstream);
            }
        }
    }

    private synchronized void loadLocaleData(InputStream inputStreamIn) {
        JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(inputStreamIn, StandardCharsets.UTF_8), JsonElement.class);
        JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"strings");
        for (Map.Entry entry : jsonobject.entrySet()) {
            ResourceLocation texture;
            String hash = (String)entry.getKey();
            ResourceLocation previous = this.skinHashToLoc.put(hash, texture = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)hash)));
            if (previous != null) {
                // empty if block
            }
            DoggyTalents2.LOGGER.info("Loaded override for {} -> {}", (Object)hash, (Object)texture);
        }
    }
}

